# 帳票設計書 32-routes.json（Bundle Analyzer）

## 概要

本ドキュメントは、`next experimental-analyze` コマンドで生成されるバンドル解析用のルート一覧JSON `routes.json` の設計仕様を定義する。

### 本帳票の処理概要

本帳票は、Next.jsプロジェクトのバンドル解析機能において、プロジェクト内の全ルート（静的ルート・動的ルート）を収集し、バンドルアナライザーUIで使用するルート一覧をJSON形式で出力するものである。

**業務上の目的・背景**：Next.jsアプリケーションの本番ビルドにおいて、各ルートのバンドルサイズを分析し、パフォーマンス最適化の機会を特定するために使用される。開発者がアプリケーションのバンドル構成を視覚的に把握できるようにすることで、不要な依存関係の削除やコード分割の改善を支援する。

**帳票の利用シーン**：(1) バンドルサイズの分析・最適化時、(2) パフォーマンスレビュー時、(3) ビルド成果物のサイズ監視時。`next experimental-analyze` コマンドの実行により、Turbopackを用いたビルドが行われ、その結果としてルート一覧が収集される。

**主要な出力内容**：
1. プロジェクト内の全ルートパスの配列（静的ルート + 動的ルート）
2. App Router / Pages Router の両方のルートを含む

**帳票の出力タイミング**：`next experimental-analyze` コマンド実行時。`--output` オプションを指定した場合はファイル出力、指定しない場合はHTTPサーバー経由で提供される。

**帳票の利用者**：フロントエンドエンジニア、パフォーマンスエンジニア、DevOpsチーム。

## 帳票種別

データマニフェスト（JSON形式のバンドル解析用データ）

## 利用画面

| 画面No | 画面名 | URL/ルーティング | 出力操作 |
|--------|--------|-----------------|---------|
| N/A | CLIコマンド | `next experimental-analyze` | コマンド実行 |
| N/A | バンドルアナライザーUI | `http://localhost:4000` | ブラウザで閲覧 |

## 出力形式

### 基本仕様

| 項目 | 内容 |
|-----|------|
| ファイル形式 | JSON |
| 用紙サイズ | N/A（ファイル出力） |
| 向き | N/A |
| ファイル名 | `routes.json` |
| 出力方法 | ファイルシステムへの書き込み、またはHTTPサーバー経由で提供 |
| 文字コード | UTF-8 |

### PDF固有設定

N/A

### Excel固有設定

N/A

## 帳票レイアウト

### レイアウト概要

JSON配列として以下の構造を持つ。

```json
[
  "/",
  "/about",
  "/blog/[slug]",
  "/api/users"
]
```

### ヘッダー部

N/A（トップレベルが配列のため）

### 明細部

| No | 項目名 | 説明 | データ取得元 | 表示形式 | 列幅 |
|----|-------|------|-------------|---------|-----|
| 1 | ルートパス | 各ルートのパス文字列 | routesManifest.dynamicRoutes + routesManifest.staticRoutes | 文字列 | N/A |

### フッター部

N/A

## 出力条件

### 抽出条件

| 条件名 | 説明 | 必須 |
|-------|------|-----|
| App Routerルート | appDir配下のルートを収集 | Yes（appDir存在時） |
| Pages Routerルート | pagesDir配下のルートを収集 | Yes（pagesDir存在時、appDirOnlyでない場合） |
| appDirOnly | App Routerのルートのみ収集するフラグ | No |

### ソート順

| 優先度 | 項目 | 昇順/降順 |
|-------|------|---------|
| 1 | ルートの種別（動的 → 静的の順で連結） | N/A |

### 改ページ条件

N/A

## データベース参照仕様

N/A（ファイルシステムのみを参照）

### 参照テーブル一覧

N/A

### テーブル別参照項目詳細

N/A

## 計算仕様

### 計算項目一覧

| 項目名 | 計算式 | 端数処理 | 備考 |
|-------|-------|---------|------|
| ルートパス（App Router） | normalizeAppPath(key) | N/A | App Router用パス正規化 |
| 全ルート一覧 | dynamicRoutes.map(r => r.page).concat(staticRoutes.map(r => r.page)) | N/A | 動的ルートと静的ルートを結合 |

## 処理フロー

### 出力フロー

```mermaid
flowchart TD
    A[next experimental-analyze 実行] --> B[loadConfig でNext.js設定読み込み]
    B --> C[turbopackAnalyze でTurbopackビルド]
    C --> D[collectRoutesForAnalyze でルート収集]
    D --> E[findPagesDir でpages/appディレクトリ検出]
    E --> F[collectAppFiles + collectPagesFiles でファイル収集]
    F --> G[createPagesMapping でマッピング作成]
    G --> H[generateRoutesManifest でルートマニフェスト生成]
    H --> I[dynamicRoutes + staticRoutes をJSON配列に変換]
    I --> J[routes.json を .next/diagnostics/analyze/data/ に書き込み]
    J --> K{--output?}
    K -->|Yes| L[ファイル出力して終了]
    K -->|No| M[HTTPサーバー起動してUI提供]
```

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 表示メッセージ | 対処方法 |
|----------|---------|--------------|---------|
| ディレクトリ不在 | pagesもappも見つからない場合 | `No pages or app directory found.` | プロジェクト構成の確認が必要 |
| ビルドエラー | Turbopackビルドが失敗した場合 | Turbopackエラーメッセージ | ソースコードの修正が必要 |
| テレメトリ記録失敗 | テレメトリ送信に失敗した場合 | エラーは抑制される | 機能に影響なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定データ件数 | 数十〜数千ルート |
| 目標出力時間 | Turbopackビルド時間に依存（数秒〜数分） |
| 同時出力数上限 | 1（CLIコマンド単発実行） |

## セキュリティ考慮事項

routes.jsonはプロジェクト内のルート構造を公開するため、本番環境では公開しないこと。`--output`オプション使用時はファイルが `.next/diagnostics/analyze/data/routes.json` に出力されるが、通常のNext.jsサーバーではこのパスは公開されない。HTTPサーバーモードではlocalhostのみにバインドされる。

## 備考

- `next experimental-analyze`は実験的機能であり、APIが変更される可能性がある
- Turbopackを使用してビルドが行われる
- `--output`オプションで結果をファイルに出力可能
- `--port`オプションでHTTPサーバーのポートを変更可能（デフォルト: 4000）
- バンドルアナライザーUIのアセットは `packages/next/src/bundle-analyzer` からコピーされる

---

## コードリーディングガイド

本帳票を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

routes.jsonはシンプルな文字列配列であるが、その元となるルートマニフェストの構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | index.ts | `packages/next/src/build/analyze/index.ts` | AnalyzeOptions型（行33-40）で入力パラメータを把握 |

**読解のコツ**: 出力は単純な文字列配列だが、内部ではroutesManifestの完全な生成プロセスを経由している。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | index.ts | `packages/next/src/build/analyze/index.ts` | analyze関数（行42-122）がメイン処理。CLIから呼び出される |

**主要処理フロー**:
1. **行51-54**: Next.js設定の読み込み
2. **行74-75**: turbopackAnalyzeでビルド実行
3. **行82**: collectRoutesForAnalyze でルート収集
4. **行84-91**: バンドルアナライザーUIをコピーし、routes.jsonを書き出し

#### Step 3: ルート収集処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | index.ts | `packages/next/src/build/analyze/index.ts` | collectRoutesForAnalyze関数（行128-208）がルート収集のコア |

**主要処理フロー**:
- **行133-134**: findPagesDirでpages/appディレクトリを検出
- **行147-149**: collectAppFilesでApp Routerファイルを収集
- **行150-152**: collectPagesFilesでPages Routerファイルを収集
- **行154-174**: createPagesMappingでマッピングを作成
- **行194-203**: generateRoutesManifestでルートマニフェストを生成
- **行205-207**: dynamicRoutes + staticRoutesからpage属性を抽出して返却

### プログラム呼び出し階層図

```
next experimental-analyze (CLI)
    │
    └─ analyze() (packages/next/src/build/analyze/index.ts)
           ├─ loadConfig() → Next.js設定読み込み
           ├─ turbopackAnalyze() → Turbopackビルド
           ├─ collectRoutesForAnalyze()
           │      ├─ findPagesDir() → ディレクトリ検出
           │      ├─ collectAppFiles() → App Routerファイル収集
           │      ├─ collectPagesFiles() → Pages Routerファイル収集
           │      ├─ createPagesMapping() → マッピング作成
           │      ├─ loadCustomRoutes() → カスタムルート読み込み
           │      └─ generateRoutesManifest() → ルートマニフェスト生成
           ├─ writeFile(routes.json) → ファイル出力
           └─ startServer() → HTTPサーバー起動（--outputなしの場合）
```

### データフロー図

```
[入力]                          [処理]                              [出力]

app/ ディレクトリ ─────────────▶ collectAppFiles()    ─┐
                                                       ├─▶ createPagesMapping() ─┐
pages/ ディレクトリ ───────────▶ collectPagesFiles()  ─┘                          │
                                                                                  ├─▶ generateRoutesManifest()
next.config.js ────────────────▶ loadCustomRoutes()  ────────────────────────────┘        │
                                                                                          ▼
                                                                               routes.json
                                                                  (.next/diagnostics/analyze/data/)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| index.ts | `packages/next/src/build/analyze/index.ts` | ソース | analyze関数・collectRoutesForAnalyze関数の実装 |
| next-build.ts | `packages/next/src/cli/next-build.ts` | ソース | CLIコマンドからanalyze関数の呼び出し |
| next.ts | `packages/next/src/bin/next.ts` | ソース | CLIエントリポイント |
| entries.ts | `packages/next/src/build/entries.ts` | ソース | collectAppFiles, collectPagesFiles, createPagesMapping関数 |
| generate-routes-manifest.ts | `packages/next/src/build/generate-routes-manifest.ts` | ソース | generateRoutesManifest関数 |
